<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'password', 'phone', 'email', 'city_id', 'status', 'code', 'image', 'api_token');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\User');
    }

    public function cartitems()
    {
        return $this->hasMany('App\Models\CartItem');
    }

    public function addresses()
    {
        return $this->hasMany('App\Models\UserAddress');
    }

}